package gov.va.genisis2.service.impl;

import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.service.IStudyApprovalService;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author 586338
 * @author Getaneh Kassahun
 *
 */
@Service
public class StudyApprovalService implements IStudyApprovalService {

	/**
	 * The studyApprovalDao
	 * 
	 * */
	@Autowired
	private IStudyApprovalDao studyApprovalDao;

	/**
	 * This method is used to getStudyApprovalDao.
	 * @return this returns studyApprovalDao.
	 * 
	 * */
	public IStudyApprovalDao getStudyApprovalDao() {
		return studyApprovalDao;
	}

	/**
	 * This method is used to setStudyApprovalDao.
	 * @param studyApprovalDao The studyApprovalDao.
	 * 
	 * */
	public void setStudyApprovalDao(IStudyApprovalDao studyApprovalDao) {
		this.studyApprovalDao = studyApprovalDao;
	}

	/**
	 * This method is used to createStudyApproval.
	 * @param studyApproval The studyApproval.
	 * @return int This returns studyApproval id.
	 */
	@Override
	public int createStudyApproval(StudyApproval studyApproval) {
		return studyApprovalDao.createStudyApproval(studyApproval);
	}
	
	/**
	 * This method is used to updateStudyApproval.
	 * @param studyApproval The studyApproval.
	 * @return int This returns studyApproval id.
	 */
	@Override
	public int updateStudyApproval(StudyApproval studyApproval) {
		return studyApprovalDao.updateStudyApproval(studyApproval);
	}

	/**
	 * This method is used to getStudyApprovalsByID.
	 * @param id The id.
	 * @return StudyApproval This returns StudyApproval.
	 */
	@Override
	public StudyApproval getStudyApprovalsByID(int id) {
		return studyApprovalDao.getStudyApprovalsByID(id);
	}

	/**
	 * This method is used to getStudyApprovalsByUID.
	 * @param uid The uid.
	 * @return this returns list of StudyApproval.
	 */
	@Override
	public List<StudyApproval> getStudyApprovalsByUID(String uid) {
		return studyApprovalDao.getStudyApprovalsByUID(uid);
	}

	/**
	 * This method is used to getStudyApprovals.
	 * @return this returns list of StudyApproval.
	 */
	@Override
	public List<StudyApproval> getStudyApprovals() {
		return studyApprovalDao.getStudyApprovals();
	}

}
